
#define REAL_SHIPS_QUANTITY 900

object	RealShips[REAL_SHIPS_QUANTITY];

ref GetRealShip(int iType) 
{ 
	if(iType >= REAL_SHIPS_QUANTITY)
	{
		trace ("--- Wrong Ship Index. iType is " + iType);
		Log_TestInfo("--- Wrong Ship Index. iType is " + iType);
		return &ShipsTypes[SHIP_TYPES_QUANTITY + 1]; //  
	}
	return &RealShips[iType]; 
}

// isLock - ,   (26.05.06 boal)
//   isLock (04.07.06)     (   )
//  1 - ,  , 0 -   -  .
int GenerateShip(int iBaseType, bool isLock)
{
	int iShip = CreateBaseShip(iBaseType);

	if (iShip == -1)
	{
		return SHIP_NOTUSED;
	}
	
	ref rRealShip = GetRealShip(iShip);
	ref rBaseShip = GetShipByType(sti(rRealShip.BaseType));
    // boal 26/05/06 
    rRealShip.ship.upgrades.hull  = 1 + rand(2);  //  
	rRealShip.ship.upgrades.sails = 1 + rand(2);  //   
	
	if (!CheckAttribute(rRealShip, "isFort"))
	{
	    int iCaliber = sti(rRealShip.MaxCaliber);
	    if (sti(rRealShip.Class) != 7)
	    {  //      16
		    switch(iCaliber)
		    {
				case 4:
					iCaliber = 0;
				break;
				case 8:
					iCaliber = 1;
				break;
				case 12:
					iCaliber = 2;
				break;
				case 16:
					iCaliber = 3;
				break;
				case 20:
					iCaliber = 4;
				break;
				case 24:
					iCaliber = 5;
				break;
				case 28:
					iCaliber = 6;
				break;
				case 32:
					iCaliber = 7;
				break;
				case 36:
					iCaliber = 8;
				break;
				case 42:
					iCaliber = 9;
				break;
				case 48:
					iCaliber = 10;
				break;
				case 92:
					iCaliber = 11;
				break;
		    }
		    iCaliber = iCaliber + rand(2) - 1;
		    if (iCaliber < 0) iCaliber = 0;
		    if (rRealShip.BaseName == "Manowar")
		    {
		    	if (iCaliber > 10) iCaliber = 10;
		    }
		    else
		    {
		    	if (iCaliber > 9) iCaliber = 9;
		    }
		    switch(iCaliber)
		    {
				case 0:
					iCaliber = 4;
				break;
				case 1:
					iCaliber = 8;
				break;
				case 2:
					iCaliber = 12;
				break;
				case 3:
					iCaliber = 16;
				break;
				case 4:
					iCaliber = 20;
				break;
				case 5:
					iCaliber = 24;
				break;
				case 6:
					iCaliber = 28;
				break;
				case 7:
					iCaliber = 32;
				break;
				case 8:
					iCaliber = 36;
				break;
				case 9:
					iCaliber = 42;
				break;
				case 10:
					iCaliber = 48;
				break;
				case 11:
					iCaliber = 92;
				break;
		    }
		    rRealShip.MaxCaliber = iCaliber;
	    }
	    rRealShip.SpeedRate	       = stf(rRealShip.SpeedRate) + frandSmall(stf(rRealShip.SpeedRate) / 5.0) - stf(rRealShip.SpeedRate) / 10.0;
	    rRealShip.TurnRate         = stf(rRealShip.TurnRate) + frandSmall(stf(rRealShip.TurnRate) / 5.0) - stf(rRealShip.TurnRate) / 10.0;
	    //rRealShip.Price            = sti(rRealShip.Price) + rand(makeint(sti(rRealShip.Price)/2)) - makeint(sti(rRealShip.Price)/4);
	    rRealShip.HP               = sti(rRealShip.HP) + rand(makeint(sti(rRealShip.HP)/5)) - makeint(sti(rRealShip.HP)/10);
	    rRealShip.WindAgainstSpeed = stf(rRealShip.WindAgainstSpeed) + frandSmall(stf(rRealShip.WindAgainstSpeed)/5.0) - stf(rRealShip.WindAgainstSpeed)/10.0;
	}
    rRealShip.Capacity        = sti(rRealShip.Capacity) + rand(makeint(sti(rRealShip.Capacity)/4)) - makeint(sti(rRealShip.Capacity)/8);
    rRealShip.OptCrew         = makeint(sti(rRealShip.OptCrew) + rand(makeint(sti(rRealShip.OptCrew)/3)) - makeint(sti(rRealShip.OptCrew)/6));
    rRealShip.MaxCrew         = makeint(sti(rRealShip.OptCrew) * 1.25 + 0.5);  // 25% 
    rRealShip.MinCrew         = makeint(sti(rRealShip.MinCrew) + rand(makeint(sti(rRealShip.MinCrew)/3)) - makeint(sti(rRealShip.MinCrew)/6));

	rRealShip.Weight		  = sti(rRealShip.Weight) + rand(sti(rRealShip.Weight)/20) - rand(sti(rRealShip.Weight)/20);
	
	// to_do del -->
	rRealShip.BoardingCrew    = 0;
	rRealShip.GunnerCrew      = 0;
	rRealShip.CannonerCrew    = 0;
	rRealShip.SailorCrew      = sti(rRealShip.OptCrew);
    // to_do del <--
    
	int iDiffWeight			= sti(rRealShip.Weight) - sti(rBaseShip.Weight);
	int iDiffCapacity		= sti(rRealShip.Capacity) - sti(rBaseShip.Capacity);
	int iDiffMaxCrew		= sti(rRealShip.MaxCrew) - sti(rBaseShip.MaxCrew);
	int iDiffMinCrew		= sti(rRealShip.MinCrew) - sti(rBaseShip.MinCrew);
	float fDiffSpeedRate	= stf(rRealShip.SpeedRate) - stf(rBaseShip.SpeedRate);
	int iDiffTurnRate		= sti(rRealShip.TurnRate) - sti(rBaseShip.TurnRate);
	int iDiffHP	    		= sti(rRealShip.HP) - sti(rBaseShip.HP);

	rRealShip.Price	= (iDiffWeight + iDiffCapacity + iDiffMaxCrew*2 + iDiffMinCrew + fDiffSpeedRate*2 + iDiffTurnRate*2 + iDiffHP)*5 + sti(rRealShip.Price);

	if (sti(rRealShip.Price) <= 0) rRealShip.Price = 100;
	
	rRealShip.Stolen = isLock;  // 

	return iShip;
}

int CreateBaseShip(int iBaseType)
{
	int iShip = FindFirstEmptyShip();

	if(iShip == -1)
	{
        trace("Can not find empty ship slot");
		return SHIP_NOTUSED;
	}

	ref rBaseShip = GetShipByType(iBaseType);
	ref rRealShip = GetRealShip(iShip);
	DeleteAttribute(rRealShip, "");
	CopyAttributes(rRealShip, rBaseShip);
    rRealShip.index = iShip;
    rRealShip.BaseType = iBaseType;
    if (!CheckAttribute(rRealShip, "ship.upgrades.hull")) //    ,   ,  
    {
    	rRealShip.ship.upgrades.hull = 1;  //  
    }
	rRealShip.ship.upgrades.sails = 1;
	
    rRealShip.BaseName = rRealShip.name; //   ,    ''
	if (rRealShip.name != "Fort" && rRealShip.name != "Boat") //    :(
	{
		rRealShip.name = rRealShip.name + "1"; //   ,  !!!!!!!!!!!!!!
		//  -       1,   
	}
    rRealShip.Stolen = 0;  //  - 
    
	if (iArcadeSails == 0) //     
	{
	    rRealShip.InertiaAccelerationY = stf(rRealShip.InertiaAccelerationY) / 2.0;
	}
    
	return iShip;
}
//    
int GenerateStoreShip(int iBaseType)
{
	int iShip = GenerateShip(iBaseType, 0); //  

	if (iShip == -1)
	{
		return SHIP_NOTUSED;
	}
	
	ref rRealShip = GetRealShip(iShip);
    rRealShip.StoreShip = true;  //   ,   
    
	return iShip;	
}
//   26.05.06 boal
// :   ,   -,   
void EmptyAllFantomShips()
{
	int  i;
	ref  chr;
	//   -  ,    .      ,  ,   
	for (i = 0; i < REAL_SHIPS_QUANTITY; i++)
	{
        DeleteAttribute(&RealShips[i], "lock");
	}
	//  ,        MAX_CHARACTERS
	RealShips[sti(Characters[BOAT_CHARACTER].ship.type)].lock = true;
	//  -
	for (i = 0; i < MAX_CHARACTERS; i++)
	{
        chr = &Characters[i];
        if (CheckAttribute(chr, "ship.type") && chr.ship.type != SHIP_NOTUSED)
        {
            RealShips[sti(chr.ship.type)].lock = true;
        }
        //   
		if (CheckAttribute(chr, "shipyard"))
		{
		    FreeShipFromShipyard(chr);
		}
	}
	for (i = FANTOM_CHARACTERS; i < TOTAL_CHARACTERS; i++) //   
	{
        chr = &Characters[i];
        if (CheckAttribute(chr, "ship.type") && chr.ship.type != SHIP_NOTUSED)
        {
            RealShips[sti(chr.ship.type)].lock = true;
        }
	}
	//   
	for (i = 0; i < REAL_SHIPS_QUANTITY; i++)
	{
        if (!CheckAttribute(&RealShips[i], "lock") && !CheckAttribute(&RealShips[i], "StoreShip"))  //     
        {
			DeleteAttribute(&RealShips[i], "");
		}
	}
}

int GetRealShipsCount()
{ //   
	int result = 0;

	for (int i= 0; i< REAL_SHIPS_QUANTITY; i++)
	{
		if (checkAttribute(&RealShips[i], "name"))
		{
			result++;
		}
	}

	return result;
}

//   
int FindFirstEmptyShip()
{
	for(int i = 0; i < REAL_SHIPS_QUANTITY; i++)
	{
		if(!checkAttribute(&RealShips[i], "name"))
		{
			return i;
		}
	}

	return -1;
}


/*
float SpeedByHullUpgrade(aref refCharacter)
{
	int iHull = sti(refCharacter.ship.upgrades.hull) - 1;

	float fResult = 1.0 - (0.05 * iHull);

	return fResult;
}


float SpeedBySailsUpgrade(aref refCharacter)
{
	int iSails = sti(refCharacter.ship.upgrades.sails) - 1;
	iSails = iSails * 5;
	float fResult = 1.0 + (0.01 * iSails);

	return fResult;
}
*/

float FindShipSpeed(aref refCharacter)
{
	if(!CheckAttribute(refCharacter, "Ship.type"))
	{
		trace("Character " + refCharacter.id + " have no ship!");
		return 0.0;
	}
	int nShipType = sti(refCharacter.ship.type);
	if(nShipType == SHIP_NOTUSED)
	{
		trace("Character " + refCharacter.id + " have invalid ship!");
		return 1.0;
	}
	ref rShip = GetRealShip(nShipType);
	
	float	fMaxSpeedZ = stf(rShip.SpeedRate);  //  
	float fShipHp = stf(refCharacter.ship.hp);
	float fShipMaxHp = stf(rShip.HP);
	float fSpeedFromHp = fShipHp/fShipMaxHp;
	fSpeedFromHp = 0.8 + fSpeedFromHp*0.3;

	if(fSpeedFromHp > 1.0) //     
	{
		fSpeedFromHp = 1.0;
	}

	float fSailsDamage = stf(refCharacter.ship.sp);

	float	fTRFromSailDamage = Bring2Range(0.1, 1.0, 0.1, 100.0, fSailsDamage); //0.3

	float fTRFromShipState = fSpeedFromHp * fTRFromSailDamage;
	
	float	fLoad = Clampf(stf(refCharacter.Ship.Cargo.Load) / stf(rShip.Capacity));
	float	fTRFromWeight = Clampf(1.03 - stf(rShip.SpeedDependWeight) * fLoad);
	float   fTRFromSkill = SpeedBySkill(refCharacter);
	//  
	float fCrewMax = stf(rShip.MaxCrew);
	float fCrewOpt = stf(rShip.OptCrew);
	float fCrewCur = stf(refCharacter.Ship.Crew.Quantity);
	if (fCrewCur > fCrewMax)
	{
		fCrewCur = fCrewMax;
	}
	float  fTRFromPeople;
	fTRFromPeople = 0.85 + ((GetCrewExp(refCharacter, "Sailors") * fCrewCur) / (fCrewOpt * GetCrewExpRate())) * 0.15;
	if (fTRFromPeople > 1) fTRFromPeople = 1;
	 
	fMaxSpeedZ = fMaxSpeedZ * fTRFromWeight * fTRFromSkill * fTRFromShipState * fTRFromPeople;

	return fMaxSpeedZ;
}

float SpeedBySkill(aref refCharacter)
{
	float fSkill = GetSummonSkillFromNameToOld(refCharacter, SKILL_SAILING);

	float fTRFromSkill = 0.7 + (0.03 *  fSkill);

	//float fSpeedByHullUpgrade = SpeedByHullUpgrade(refCharacter);
	//float fSpeedBySailsUpgrade = SpeedBySailsUpgrade(refCharacter);

	//fTRFromSKill = fTRFromSKill * fSpeedByHullUpgrade * fSpeedBySailsUpgrade;
    float fSpeedPerk = AIShip_isPerksUse(CheckOfficersPerk(refCharacter, "ShipSpeedUp"), 1.0, 1.15);   //slib
    fSpeedPerk = AIShip_isPerksUse(CheckOfficersPerk(refCharacter, "SailingProfessional"), fSpeedPerk, 1.20);
    
	return fTRFromSKill*fSpeedPerk;
}

float FindShipTurnRate(aref refCharacter)
{
	if(!CheckAttribute(refCharacter, "Ship.type"))
	{
		trace("Character " + refCharacter.id + " have no ship!");
		return 0.0;
	}
	int nShipType = sti(refCharacter.ship.type);
	if(nShipType == SHIP_NOTUSED)
	{
		trace("Character " + refCharacter.id + " have invalid ship!");
		return 1.0;
	}
	ref rShip = GetRealShip(nShipType);

	float fShipHp = stf(refCharacter.ship.hp);
	float fShipMaxHp = stf(rShip.HP);
	float fSpeedFromHp = fShipHp/fShipMaxHp;
	fSpeedFromHp = 0.7 + fSpeedFromHp * 0.3;

	float fLoad = Clampf(stf(refCharacter.Ship.Cargo.Load) / stf(rShip.Capacity));
	float fTRFromWeight;
	if (iArcadeSails == 1)
	{
		fTRFromWeight = Clampf(1.03 - stf(rShip.TurnDependWeight) * fLoad);
	}
	else
	{
		fTRFromWeight = Clampf(1.03 - 2.0*stf(rShip.TurnDependWeight) * fLoad); //   
	}
	//  ,  1 float fTRFromSpeed = 1.0 - stf(rShip.TurnDependSpeed);
	//  
	//float fCrewMin = stf(rShip.MinCrew);
	float fCrewMax = stf(rShip.MaxCrew);
	float fCrewOpt = stf(rShip.OptCrew);
	float fCrewCur = stf(refCharacter.Ship.Crew.Quantity);
	if (fCrewCur > fCrewMax)
	{
		fCrewCur = fCrewMax;
	}
	float  fTRFromPeople;
	if (iArcadeSails == 1)
	{
		fTRFromPeople = 0.3 + ((GetCrewExp(refCharacter, "Sailors") * fCrewCur) / (fCrewOpt * GetCrewExpRate())) * 0.7;
	}
	else
	{
		fTRFromPeople = 0.05 + ((GetCrewExp(refCharacter, "Sailors") * fCrewCur) / (fCrewOpt * GetCrewExpRate())) * 0.95;
	}
	if (fTRFromPeople > 1) fTRFromPeople = 1;
	
	float fTRFromSKill = TurnBySkill(refCharacter);

	float fTRFromSailDamage = Bring2Range(0.05, 1.0, 0.1, 100.0, stf(refCharacter.ship.sp));

	float fTurn = fTRFromWeight * fTRFromSkill * fTRFromPeople * fTRFromSailDamage * fSpeedFromHp;

	//Log_info(refCharacter.id + "  " + fTurn);
	return fTurn;	
}

float TurnBySkill(aref refCharacter)
{
	float fSkill = GetSummonSkillFromNameToOld(refCharacter, SKILL_SAILING);
	float fTRFromSKill;

    if (iArcadeSails == 1)
	{
		fTRFromSKill = 0.5 + (0.05 * fSkill);
	}
	else
	{
		fTRFromSKill = 0.3 + (0.07 * fSkill);
	}
	
    float fSpeedPerk = AIShip_isPerksUse(CheckOfficersPerk(refCharacter, "ShipTurnRateUp"), 1.0, 1.15);   //slib
    fSpeedPerk = AIShip_isPerksUse(CheckOfficersPerk(refCharacter, "SailingProfessional"), fSpeedPerk, 1.20);
    float fFastTurn180 = AIShip_isPerksUse(CheckOfficersPerk(refCharacter, "Turn180"), 1.0, 8.0);
    
	return fTRFromSKill*fSpeedPerk*fFastTurn180;
}

int GetCannonsNum(aref chr)
{
	int nShipType = sti(chr.ship.type);
    ref refBaseShip = GetRealShip(nShipType);

	int iCannons = GetBortIntactCannonsNum(chr, "cannonf", sti(refBaseShip.fcannon)) + GetBortIntactCannonsNum(chr, "cannonb", sti(refBaseShip.bcannon)) + GetBortIntactCannonsNum(chr, "cannonl", sti(refBaseShip.lcannon)) + GetBortIntactCannonsNum(chr, "cannonr", sti(refBaseShip.rcannon));

	return iCannons;
}

// boal
int GetBortCannonsQty(aref chr, string  sType)
{
	int nShipType = sti(chr.ship.type);
    ref refBaseShip = GetRealShip(nShipType);

	int iCannons = GetBortIntactCannonsNum(chr, sType, sti(refBaseShip.(sType)));

	return iCannons;
}

int GetBortCannonsMaxQty(aref chr, string  sType)
{
	int nShipType = sti(chr.ship.type);
    ref refBaseShip = GetRealShip(nShipType);

	int iCannons = sti(refBaseShip.(sType));

	return iCannons;
}

///////////////////////   //////////////////////
void SetShipyardStore(ref NPChar)
{
    int    iTest_ship, i;
	string attrName;
	
	if (CheckAttribute(NPChar, "shipyard")) return; //      
	
	SaveCurrentNpcQuestDateParam(npchar, "shipyardDate"); //   
    
    if (bBettaTestMode)
    {
        for (i = 1; i <=SHIP_TYPES_QUANTITY; i++)
        {
            attrName = "ship" + i;
            FillShipParamShipyard(NPChar, GenerateStoreShip(i-1), attrName);
        }
        
        return;
    }
    

    FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_TARTANE), "ship1");
    
	iTest_ship = rand(5);
	if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LUGGER), "ship3");
	if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BERMSLOOP), "ship3");


	iTest_ship = rand(6);
	if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LUGGER), "ship3");
	if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BERMSLOOP), "ship3");
	if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HANNAH), "ship3");

	
	if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
	{
		iTest_ship = rand(12);
	if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LUGGER), "ship4");
	if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BERMSLOOP), "ship4");
	if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HANNAH), "ship4");
	if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_KETCH), "ship4");
	if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BOUNTY), "ship4");
	if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOP), "ship4");
	if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_EMPRESS), "ship4");
	}
	else // = If Realistic SHIP PURCHASE IS enabled
	{
		iTest_ship = rand(6);
	if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LUGGER), "ship4");
	if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BERMSLOOP), "ship4");
	if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HANNAH), "ship4");
	}	
	

	if (sti(PChar.rank) > 1)
	{
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(28); //50% chance to get a ship here
	if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LUGGER), "ship5");
	if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BERMSLOOP), "ship5");
	if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HANNAH), "ship5");
	if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_KETCH), "ship5");
	if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BOUNTY), "ship5");
	if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOP), "ship5");
	if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARQUE), "ship5");
	if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARKENTINE), "ship5");
	if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_EMPRESS), "ship5");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(10); //50%
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BERMSLOOP), "ship5");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HANNAH), "ship5");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_KETCH), "ship5");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BOUNTY), "ship5");
		}		

		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(46); //50%
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_EMPRESS), "ship6");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOP), "ship6");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARQUE), "ship6");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARKENTINE), "ship6");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIGANTINE), "ship6");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG), "ship6");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FLEUT), "ship6");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(10); //50%
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BERMSLOOP), "ship6");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HANNAH), "ship6");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_KETCH), "ship6");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BOUNTY), "ship6");
		}
	}
	if (sti(PChar.rank) > 3)
	{	
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{	
			iTest_ship = rand(60); //33% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG), "ship8");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FLEUT), "ship8");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LUGGER_H), "ship8");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEOTH_H), "ship8");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_YACHT), "ship8");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SPEEDY), "ship8");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PINNACE), "ship8");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(12); //33% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HANNAH), "ship8");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_KETCH), "ship8");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BOUNTY), "ship8");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOP), "ship8");
		}

		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(48); //33% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SPEEDY), "ship9");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PINNACE), "ship9");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SOPHIE), "ship9");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CASTELF), "ship9");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_INTERCEPTOR), "ship9");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_DERFFLINGER), "ship9");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER), "ship9");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(12); //33% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_KETCH), "ship9");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BOUNTY), "ship9");		
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOP), "ship9");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARQUE), "ship9");
		}

		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(48); //33% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_INTERCEPTOR), "ship10");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_DERFFLINGER), "ship10");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER), "ship10");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEON_L), "ship10");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_DUTCHPINNACE), "ship10");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PINNACEBERLIN), "ship10");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(12); //33% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BOUNTY), "ship10");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOP), "ship10");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARQUE), "ship10");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARKENTINE), "ship10");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIGANTINE), "ship10");
		}
	}

	if (sti(PChar.rank) > 5)
	{	
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(88); //20% chance of a ship here
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEON_L), "ship11");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_DUTCHPINNACE), "ship11");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PINNACEBERLIN), "ship11");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NEPTUNUS ), "ship11");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GREYHOUND), "ship11");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_28GUNFRIGATE), "ship11");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PDN), "ship11");
		if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PACKET_BRIG), "ship11");
		if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_ENTERPRISE), "ship11");
		if (iTest_ship == 10) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG_20_GUN1_18), "ship11");
		if (iTest_ship == 11) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER_L), "ship11");
		if (iTest_ship == 12) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SHNYAVA), "ship11");
		if (iTest_ship == 13) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HOOKER1), "ship11");
		if (iTest_ship == 14) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG3), "ship11");

		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(20); //20% 
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOP), "ship11");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARQUE), "ship11");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARKENTINE), "ship11");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIGANTINE), "ship11");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG), "ship11");
		}
	
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP purchase is NOT enabled
		{
			iTest_ship = rand(100);  //20% 
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NEPTUNUS ), "ship12");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GREYHOUND), "ship12");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_28GUNFRIGATE), "ship12");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PDN), "ship12");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PACKET_BRIG), "ship12");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_ENTERPRISE), "ship12");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOPOFWAR), "ship12");
		if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG_20_GUN1_18), "ship12");
		if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER_L), "ship12");
		if (iTest_ship == 10) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SHNYAVA), "ship12");
		if (iTest_ship == 11) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HOOKER1), "ship12");
		if (iTest_ship == 12) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG3), "ship12");
		if (iTest_ship == 13) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CARAVEL), "ship12");
		if (iTest_ship == 14) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEON_H), "ship12");
		if (iTest_ship == 15) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CORVETTE), "ship12");
		if (iTest_ship == 16) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FELIPE), "ship12");
		if (iTest_ship == 17) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SURPRISE), "ship12");
		if (iTest_ship == 18) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CORVFRIG2_50), "ship12");
		if (iTest_ship == 19) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_RaaFrigate), "ship12");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(20); //20% 
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARQUE), "ship12");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BARKENTINE), "ship12");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIGANTINE), "ship12");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG), "ship12");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LUGGER_H), "ship12");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEOTH_H), "ship12");
		}
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(95); //20% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BLACKPEARL), "ship13");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NIGHTMARE), "ship13");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_UNICORN), "ship13");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEON_H), "ship13");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CORVETTE), "ship13");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FELIPE), "ship13");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SURPRISE), "ship13");
		if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CORVFRIG2_50), "ship13");
		if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_RaaFrigate), "ship13");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(20); //20% 
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIGANTINE), "ship13");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG), "ship13");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LUGGER_H), "ship13");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEOTH_H), "ship13");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_YACHT), "ship13");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SPEEDY), "ship13");
		}
	}
	if (sti(PChar.rank) > 8)
	{	
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(525); //4% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CORVETTE), "ship14");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FELIPE), "ship14");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SURPRISE), "ship14");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CORVFRIG2_50), "ship14");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_RaaFrigate), "ship14");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEON_H), "ship14");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_QueenAnnesRevenge), "ship14");
		if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FRIGATE), "ship14");
		if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LINESHIP), "ship14");
		if (iTest_ship == 10) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_ARABELLA), "ship14");

		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(100); //4% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GALEOTH_H), "ship14");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_YACHT), "ship14");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SPEEDY), "ship14");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SOPHIE), "ship14");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_INTERCEPTOR), "ship14");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER), "ship14");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NEPTUNUS), "ship14");
		if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG_20_GUN1_18), "ship14");
		if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER_L), "ship14");
		if (iTest_ship == 10) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SHNYAVA), "ship14");
		if (iTest_ship == 11) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HOOKER1), "ship14");
		if (iTest_ship == 12) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG3), "ship14");

		}
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(700); // 2.8% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_QueenAnnesRevenge), "ship14");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FRIGATE), "ship15");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LINESHIP), "ship15");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_ARABELLA), "ship15");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_QueenAnnesRevenge), "ship15");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_Revenge), "ship15");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BOUSSOLE), "ship15");
		if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SALAMANDER), "ship15");
		if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LINEFRIGATE), "ship15");
		if (iTest_ship == 10) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_TWODECKER1_47), "ship15");
		if (iTest_ship == 11) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_USS_CONSTITUTION), "ship15");
		if (iTest_ship == 12) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LA_LICORNE), "ship15");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(140); //2.8% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SPEEDY), "ship15");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SOPHIE), "ship15");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_INTERCEPTOR), "ship15");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER), "ship15");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NEPTUNUS), "ship15");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG_20_GUN1_18), "ship15");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER_L), "ship15");
		if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SHNYAVA), "ship15");
		if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HOOKER1), "ship15");
		if (iTest_ship == 10) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG3), "ship15");

		}
	}

	if (sti(PChar.rank) > 12)
	{
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(425); //4% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LINEFRIGATE), "ship141");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_TWODECKER1_47), "ship141");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_USS_CONSTITUTION), "ship141");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LA_LICORNE), "ship141");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CURSEDDUTCHMAN), "ship141");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_RN_BATTLEFRIGATE), "ship141");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FASTGALLEON1), "ship141");
		if (iTest_ship == 9) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_WARSHIP), "ship141");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(175); //4% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_INTERCEPTOR), "ship141");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SCHOONER), "ship141");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NEPTUNUS), "ship141");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SHNYAVA), "ship141");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HOOKER1), "ship141");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BRIG3), "ship141");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GREYHOUND), "ship141");
		if (iTest_ship == 8) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PDN), "ship141");
	}
		
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(595); //2.8% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_CURSEDDUTCHMAN), "ship151");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_RN_BATTLEFRIGATE), "ship151");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FASTGALLEON1), "ship151");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_WARSHIP), "ship151");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BATTLESHIP), "ship151");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BELLONA), "ship151");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_POSEIDON), "ship151");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(280); //2.8% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NEPTUNUS), "ship151");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GREYHOUND), "ship151");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PDN), "ship151");
		}
	}
	if (sti(PChar.rank) > 18)
	{
		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(480); //2.5% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BELLONA), "ship16");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_POSEIDON), "ship16");
	   	if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_COURONNE), "ship16");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NEPTUNE), "ship16");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FR_SUPERIORWARSHIP1), "ship16");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(280); //2.5% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_GREYHOUND), "ship16");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PDN), "ship16");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PACKET_BRIG), "ship16");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_ENTERPRISE), "ship16");
		}

		if(!REALISTIC_SHIP_PURCHASE) // = If Realistic SHIP PURCHASE is NOT enabled
		{
			iTest_ship = rand(400); //2.5% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_NEPTUNE), "ship17");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_FR_SUPERIORWARSHIP1), "ship17");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SUPERBE), "ship17");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_LINK), "ship17");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_MANOWAR), "ship17");
		if (iTest_ship == 6) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_HMS_VICTORY), "ship17");
		if (iTest_ship == 7) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_BATTLEMANOWAR), "ship17");
		}
		else // = If Realistic SHIP PURCHASE IS enabled
		{
			iTest_ship = rand(280); //2.5% chance
		if (iTest_ship == 1) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PDN), "ship17");
		if (iTest_ship == 2) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_PACKET_BRIG), "ship17");
		if (iTest_ship == 3) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_ENTERPRISE), "ship17");
		if (iTest_ship == 4) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_SLOOPOFWAR), "ship17");
		if (iTest_ship == 5) FillShipParamShipyard(NPChar, GenerateStoreShip(SHIP_28GUNFRIGATE), "ship17");
		}
	}
}

void FreeShipFromShipyard(ref NPChar)
{
	if (GetNpcQuestPastDayParam(NPChar, "shipyardDate") > (3 + rand(6)))
	{
        aref   arDest, arImt;
		string sAttr;
		int    iNum, i, iShip;
		makearef(arDest, NPChar.shipyard);
		iNum = GetAttributesNum(arDest);
		for (i = 0; i < iNum; i++)
		{
	    	arImt = GetAttributeN(arDest, i);
	    	iShip = sti(arImt.Type); //GetAttributeValue(arImt));
	    	DeleteAttribute(&RealShips[iShip], "StoreShip"); //  
	    }
        DeleteAttribute(NPChar, "shipyard");
	}
}

void FillShipParamShipyard(ref NPChar, int _iType, string _sShipNum)
{
    aref    arTo, arFrom;
    
	DeleteAttribute(NPChar, "ship");
    NPChar.Ship.Type = _iType;
    
	SetRandomNameToShip(NPChar);

    SetBaseShipData(NPChar);
    SetCrewQuantity(NPChar, 0);
    if (sti(NPChar.Ship.Cannons.Type) != CANNON_TYPE_NONECANNON)
    {
    	NPChar.Ship.Cannons.Type = CANNON_TYPE_CANNON_LBS4; // to_do      
    }
    DeleteAttribute(NPChar, "Ship.Cargo");  // 
    SetGoodsInitNull(NPChar);
    RecalculateCargoLoad(NPChar);
    
    FillShipyardShipBack(NPChar, _sShipNum);
}

void FillShipyardShip(ref NPChar, string _sShipNum)
{
    aref    arTo, arFrom;

	DeleteAttribute(NPChar, "ship");

    makearef(arFrom,   NPChar.shipyard.(_sShipNum));
    NPChar.Ship = "";
	makearef(arTo, NPChar.Ship);
	CopyAttributes(arTo, arFrom);
}

void FillShipyardShipBack(ref NPChar, string _sShipNum)
{
    aref    arTo, arFrom;

  	DeleteAttribute(NPChar, "shipyard." + _sShipNum);
    NPChar.shipyard.(_sShipNum) = "";
    makearef(arTo,   NPChar.shipyard.(_sShipNum));
	makearef(arFrom, NPChar.Ship);
	CopyAttributes(arTo, arFrom);
}

//    
string GetShip_deck(ref chr, bool map2sea)
{
	string ret, add;
	int    iType = sti(chr.Ship.Type);
	if (map2sea)
	{
	    ret = "Ship_deck_";
	}
	else
	{
	    ret = "Deck_Near_Ship_";
	}
	add = "Low"; //   
	if (iType != SHIP_NOTUSED)
	{
        ref rRealShip = GetRealShip(iType);
        
		add = rRealShip.DeckType;
	}
	
	return ret + add;
}

void MakeCloneShipDeck(ref chr, bool map2sea)
{
	ref rOrg, rClone;
	int iOrg, iClone;
    string locId, toLocId;
    
    locId = GetShip_deck(chr, map2sea);
    if (map2sea)
	{
	    toLocId = "Ship_deck";
	}
	else
	{
	    toLocId = "Deck_Near_Ship";
	}
	
	iOrg = FindLocation(locId);
	iClone = FindLocation(toLocId);

	makeref(rOrg, Locations[iOrg]);
	makeref(rClone, Locations[iClone]);

	DeleteAttribute(rClone, "");
	CopyAttributes(rClone, rOrg);
	rClone.id = toLocId;
	rClone.index = iClone;
}

void MakeCloneFortBoarding(string fromLocId)
{
	ref rOrg, rClone;
	int iOrg, iClone;
    string toLocId;
    
    toLocId = "BOARDING_FORT";

	iOrg = FindLocation(fromLocId);
	iClone = FindLocation(toLocId);

	makeref(rOrg, Locations[iOrg]);
	makeref(rClone, Locations[iClone]);

	DeleteAttribute(rClone, "");
	CopyAttributes(rClone, rOrg);
	rClone.id = toLocId;
	rClone.index = iClone;
	
    rClone.type = "fort_attack";
	LAi_LocationFantomsGen(rClone, false);
	DeleteAttribute(rClone, "reload");
	//    .   goto, soldiers  .  rld  .
	if (rClone.models.always.locators == "fortV_locators") 
	{
		rClone.models.always.locators = "fortV_lAttack";
		rClone.models.always.fortV = "fortV_attack";	
	}
	else
	{
		rClone.models.always.locators = "fortVRight_lAttack";
		rClone.models.always.fortV = "fortVRight_attack";
	}
	rClone.boarding.locatorNum = 15;
	rClone.boarding = "false";
	rClone.boarding.nextdeck = "";
	rClone.image = "loading\Fort_512.tga";
}